/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common;

import java.util.Locale;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.block.BlockStairsBase;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemBlockSlab;

public class PulseBase {
    public static boolean isBuildingLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsBuilding");
    }

    public static boolean isUtilityLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsUtility");
    }

    public static boolean isTweaksLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsTweaks");
    }

    public static boolean isRecipesLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsRecipes");
    }

    public static boolean isToolsLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsTools");
    }

    protected static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        PulseBase.register(registry, block, name);
        return block;
    }

    protected static <T extends Item> T registerItem(IForgeRegistry<Item> registry, T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(Util.prefix(name));
        PulseBase.register(registry, item, name);
        return item;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockStairsBase registerBlockStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return PulseBase.registerBlock(registry, new BlockStairsBase(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static ItemBlockMeta registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        return PulseBase.registerItemBlock(registry, new ItemBlockMeta(block));
    }

    protected static ItemBlockMeta registerEnumItemBlock(IForgeRegistry<Item> registry, EnumBlock<?> block) {
        return PulseBase.registerItemBlock(registry, block, block.prop);
    }

    protected static <T extends ItemBlockMeta> T registerItemBlock(IForgeRegistry<Item> registry, T itemBlock, IProperty<?> property) {
        PulseBase.registerItemBlock(registry, itemBlock);
        ItemBlockMeta.setMappingProperty((Block)itemBlock.func_179223_d(), property);
        return itemBlock;
    }

    protected static <T extends ItemBlock> T registerItemBlock(IForgeRegistry<Item> registry, T itemBlock) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        PulseBase.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        return itemBlock;
    }

    protected static ItemBlockMeta registerItemBlock(IForgeRegistry<Item> registry, Block block, IProperty<?> property) {
        return PulseBase.registerItemBlock(registry, new ItemBlockMeta(block), property);
    }

    protected static <T extends Enum<T> & IStringSerializable> ItemBlockSlab<T> registerEnumItemBlockSlab(IForgeRegistry<Item> registry, EnumBlockSlab<T> block) {
        return PulseBase.registerItemBlock(registry, new ItemBlockSlab(block), block.prop);
    }

    protected static <C extends T, T extends IForgeRegistryEntry<T>> C register(IForgeRegistry<T> registry, C thing, String name) {
        return PulseBase.register(registry, thing, Util.getResource(name));
    }

    protected static <C extends T, T extends IForgeRegistryEntry<T>> C register(IForgeRegistry<T> registry, C thing, ResourceLocation name) {
        thing.setRegistryName(name);
        registry.register(thing);
        return thing;
    }

    protected static <T extends Entity> EntityEntryBuilder<T> getEntityBuilder(Class<T> clazz, String name, int id) {
        return EntityEntryBuilder.create().entity(clazz).id(Util.getResource(name), id).name(Util.prefix(name));
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (ResourceLocation)Util.getResource(name));
    }

    protected static Fluid registerColoredFluid(String name, int color) {
        Fluid fluid = PulseBase.registerFluid(new Fluid(name, Util.getResource("blocks/fluid_colorless"), Util.getResource("blocks/fluid_colorless_flow"), color));
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        return fluid;
    }

    protected static <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName(Util.prefix(fluid.getName()));
        FluidRegistry.registerFluid(fluid);
        return fluid;
    }

    protected static void registerDispenserBehavior(Block block, IBehaviorDispenseItem behavior) {
        if (block != null) {
            PulseBase.registerDispenserBehavior(Item.func_150898_a((Block)block), behavior);
        }
    }

    protected static void registerDispenserBehavior(Item item, IBehaviorDispenseItem behavior) {
        if (item != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)behavior);
        }
    }

    protected static void addToVanillaLoot(LootTableLoadEvent event, String name) {
        ResourceLocation extra = Util.getResource(name);
        event.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryTable(extra, 1, 0, new LootCondition[0], "inspirations")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "inspirations"));
    }
}

